/****************************************************************************

    Neural Network Library example program.
    Copyright (C) 1998 Daniel Franklin

	Modifie par B. Decoux pour les TP RDF EFREI 2003-2004
		decoux@efrei.fr	www-rdf.efrei.fr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <iostream>
#include <iomanip.h>
#include <math.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <alloc.h>
#include "nnwork.h"
#include "rdf.h"
#include "define.h"

#define NB_CLASSES_MAX	50
#define NB_VEC_MAX		100000

class classifieur {
	public:
				//en chantier
};

// Test en reconnaissance : presentation de tous les vecteurs de la base de test au reseau (=validatoin croisee)
void
test_reco(nnwork *brain, UWORD nb_cl, Vec *vec_a, ULONG nb_vec_a, Vec *vec_t, ULONG nb_vec_t, FLOAT *result, ULONG taux_aff, FLOAT *tr_moy_a, FLOAT *tr_moy_t)
{
	int		*ident, *diff;			// variables pour le calcul des taux de reconnaissance
	float		*taux_r;
	float		tr_moy;				// taux de reconnaissance moyen
	Vec		*vec_tmp;			// pointeur sur l'une ou l'autre des 2 listes de vecteurs (app. et test), pour le test de classification
	int		nb_vec_tmp;			// nombre de vecteurs de la liste pointée par "vec_tmp"
	float		max;
	int		max_idx;
	int		i, j, k, l, num;

	ident=(int*)calloc(nb_cl, sizeof(int));					// pour les statistiques de reconnaissance : nombre de vecteurs 
	diff=(int*)calloc(nb_cl, sizeof(int));						// dont la classe indiquee par l'algo est identique a la classe reelle
	taux_r=(float*)calloc(nb_cl, sizeof(float));				// taux de reconnaissance
	for(l=0 ; l<2 ; l++)
	{
		for(i=0 ; i<nb_cl ; i++)
			(*(ident+i))=(*(diff+i))=0;
		if(l==0)
		{
			vec_tmp=vec_a;
			nb_vec_tmp=nb_vec_a;
		}
		else if(l==1)
		{
			vec_tmp=vec_t;
			nb_vec_tmp=nb_vec_t;
		}
		for(j=0 ; j<nb_vec_tmp ; j++)
		{
			for (i=0 ; i<nb_cl ; i++)						// init du tableau des sorties desirees
				result[i]=0.1;
			result[(vec_tmp+j)->n_cl-1]=0.9;
			(*brain).run( (vec_tmp+j)->comp, result);
		   // Get the best match
			max=0.;
			max_idx=0;
			for(i=0 ; i<nb_cl ; i++)
				if(result[i]>max)
				{
					max=result[i];
					max_idx=i;
				}
		   // Compteurs de bonnes et de mauvaises reponses pour le calcul des statistiques de reconnaissance
			for(k=0 ; k<nb_cl ; k++)
			   if((vec_tmp+j)->n_cl==k+1)
				if(max_idx==(vec_tmp+j)->n_cl-1)
					(*(ident+k))++;
				else
					(*(diff+k))++;
		}
	// Calcul des statistiques de reconnaissance
		for(i=0 ; i<nb_cl ; i++)
			*(taux_r+i)=100.*(float)(*(ident+i))/(*(ident+i)+*(diff+i));
		tr_moy=0.;
//		printf("Resultats (taux de reconnaissance) :\n");
		for(i=0 ; i<nb_cl ; i++)
		{
//			printf("\tClasse %d : %.2f\n", i+1, *(taux_r+i));
			tr_moy+=*(taux_r+i);
		}
		tr_moy/=nb_cl;
		if(l==0)
		{
			*tr_moy_a=tr_moy;
			printf("Taux moyen sur les donnees d'apprentissage : %.2f\n", tr_moy);
		}
		else if(l==1)
		{
			*tr_moy_t=tr_moy;
			printf("Taux moyen sur les donnees de test : %.2f\n", tr_moy);
		}
	}
	free(taux_r);
	free(diff);
	free(ident);
}

// Algorithme de retropropagation du gradient
int
retro_propag_gradient(nnwork *brain, Vec *vec, int nb_vec, int *num_cl, int nb_car, int nb_cl, int *nb_vec_cl, int nb_iter_app, int nncc, float alpha)
{
	float		result[NB_CLASSES_MAX];
	float		range;
	int		i, j, k, l, num;
	char		character;
   // Variables ajoutees par rapport au programme original
	Vec		*vec_a;				// liste des vecteurs d'apprentissage
	Vec		*vec_t;				// liste des vecteurs de test
	int		nb_vec_a, nb_vec_t;	// nombre de vecteurs dans les 2 listes (resp. apprentissage et test)
	int		*num_cl_a, *num_cl_t;	// numero de classe des vecteurs dans les 2 listes (resp. apprentissage et test)
	int		taux_aff=100;
	TEXT	nom_fich_a[200], nom_fich_t[200], chaine[100];
	FLOAT	tr_moy_a, tr_moy_t;
	int		compt;


	vec_a=creation_vecteurs_donnees(nb_vec, nb_car);		// vecteurs d'apprentissage (liste surdimensionnee)
	vec_t=creation_vecteurs_donnees(nb_vec, nb_car);		// vecteurs de test
	num_cl_a=(int*)calloc(nb_vec, sizeof(int));				// numero de classe des vecteurs d'apprentissage
	num_cl_t=(int*)calloc(nb_vec, sizeof(int));				// numero de classes des vecteurs de test

	gene_bases_app_et_reco(vec, nb_vec, nb_car, nb_cl, num_cl, nb_vec_cl, vec_a, &nb_vec_a, num_cl_a, vec_t, &nb_vec_t, num_cl_t);

	srand((unsigned)time(NULL));

   // Initially, all cell entries other than result [0] are "false"
   // note that "result" is used both for training (desired result) and running.

	for (i=0; i<nb_cl ; i++)
		result[i]=0.1;
		
	srandom (time (0));
	
	cout << "Train or read from file (t|f)? ";
	cin >> character;

   // Apprentissage : modification des poids (ou lecture des poids dans un fichier)
	if(character == 't')
	{
		for(i=0 ; i<nb_iter_app ; i++)
		{
		   // choix aleatoire d'un vecteur dans la liste
			num=(int)(nb_vec_a*alea_0a1());
		   // Sorties desirees : set cell j to "true", the other to "false"
			for (k=0 ; k<nb_cl ; k++)
				result[k]=0.1;
			result[(vec_a+num)->n_cl-1]=0.9;
		   // Train the network
			(*brain).train ((vec_a+num)->comp, result, 0., alpha);
			if(i%(nb_iter_app/taux_aff)==0)
			{
				cout << "Iter. " <<  i << " : test reco : "<< endl;
				test_reco(brain, nb_cl, vec_a, nb_vec_a, vec_t, nb_vec_t, result, taux_aff, &tr_moy_a, &tr_moy_t);
			}
		}
	    // Save the data
		(*brain).save ("tmp.nnw");
	}
	else if (!(*brain).load ("tmp.nnw"))	// Or attempt to load the data
	{
		cerr << "File not found.\n";
		return -1;
	}

    // il faut liberer la place
	destruct_vecteurs_donnees(vec_a, nb_vec);
	destruct_vecteurs_donnees(vec_t, nb_vec);
	free(num_cl_a);
	free(num_cl_t);

	return 0;
}
int
lect_int_param(char *param)
{
	int	compt;
	int	rang;
	int	parametre;
	int	j;
	int	p2[10];
	int p=param[2]-'0';

	j=0;
	compt=0;
	while(p>=0 && p<=9)
	{
		p2[j]=param[j+2]-'0';
		compt++;
		p=p2[j];
		j++;
	}		//pour acquerir tous les chiffres du nombre entre en commande
	compt--;
	parametre=0;
	rang=1;
	for(j=0 ; j<compt ; j++)
	{
		parametre+=p2[compt-j-1]*rang;
		rang*=10;
	}
	return parametre;
}
//pour lire un float dans la ligne de commande
float
lect_float_param(char *param)
{
	int	compt;
	float	rang;
	float	parametre;
	int	j;
	int	p2[10];
	char	p=param[2]-'0';
	int	pos;			// position de la virgule

	j=0;
	compt=0;
	while((p>=0 && p<=9) || p==',' || p=='.')
	{
		if(param[j+2] == ',' || param[j+2]=='.')
			pos=compt;		// position de la virgule
		else
		{
			p2[compt]=param[j+2]-'0';
			p=p2[compt];
			compt++;
		}
		j++;
	}		//pour acquerir tous les chiffres du nombre entre en commande
	compt--;
	parametre=0;
	rang=1;
	for(j=compt-pos ; j<compt ; j++)		// chiffres a gauche de la virgule
	{
		parametre+=p2[compt-j-1]*rang;
		rang*=10;
	}
	rang=0.1;
	for(j=pos ; j<compt ; j++)		// chiffres a droite de la virgule
	{
		parametre+=p2[j]*rang;
		rang/=10.;
	}
	return parametre;
}
int
main(int argc, char *argv[])
{
	int		nb_vec, nb_car, nb_cl;
	int		*nb_vec_cl;
	Vec		*vec;
	char		param[10];
	int		i, j, l;
	float		tr_moy;
	char		**nom_cl_i;			// pour le nom des classes
	time_t	debut, fin;				// pour mesurer la duree de l'algorithme
	int		nb_iter_app;
	int		nncc;				// nombre de neurones dans la couche cachee
	int		*num_cl;
	float		alpha;
	char		nom_fich[50];

	srand((unsigned)time( NULL )); 	// init du generateur aleatoire
	if(argc<2)
	{
		cout << "Utilisation : ./rpg <nom_fich.don>" << endl;
		exit(0);
	}
	else
	{
		strcpy(nom_fich, argv[1]);
	   // parametres par defaut
		nb_iter_app=100000;
		nncc=10;
		alpha=0.1;
	   // lecture des parametres de la ligne de commande
		for(i=2 ; i<argc ; i++)
	  	{
		    strcpy(param, argv[i]);
		    if(param[1]=='=')
		    {
			  switch(param[0])
			  {
				case 'c' :	nncc=lect_int_param(param);				break;
				case 'i' :	nb_iter_app=lect_int_param(param);		break;
				case 'a' :	alpha=lect_float_param(param);			break;
				default :	break;
			}
		}
	}
	}
	cout << "-----------------------Classifieur------------------------" << endl ;
	nom_cl_i=(char**)calloc(NB_CLASSES_MAX, sizeof(char*));
	for(i=0 ; i<NB_CLASSES_MAX ; i++)
		*(nom_cl_i+i)=(char*)calloc(50, sizeof(char));
	nb_vec_cl=(int*)calloc(NB_CLASSES_MAX, sizeof(int));
	num_cl=(int*)calloc(NB_VEC_MAX, sizeof(int));
	lect_info_fich_donnees2(nom_fich, &nb_car, &nb_vec, &nb_cl, nb_vec_cl, nom_cl_i,  (int*)num_cl);
	cout << "Informations fichier de donnees : " << endl;
	cout << "\tNombre de variables : " << nb_car << endl;
	cout << "\tNombre de vecteurs : " << nb_vec << endl;
	cout << "\tNombre de classes : " << nb_cl << endl;
	cout << "\tNombre d'exemples pour chaque classe : " << endl;
	for(i=0 ; i<nb_cl ; i++)
		cout << "\t\tClasse" << i+1 << ":" <<  *(nb_vec_cl+i) << "(nom :" << *(nom_cl_i+i) << ")" << endl;
	vec=creation_vecteurs_donnees(nb_vec, nb_car);
	charge_donnees_fich(nom_fich, vec, nb_vec, nb_car, nb_cl, nom_cl_i);

	normalis_vecs(vec, nb_vec, nb_car);

	// CREATION DU RESEAU
	cout << "Paramètres : nncc=" << nncc << ", alpha= "<< alpha << " , nb iter app : " << nb_iter_app << " "<< endl;
	nnwork brain(nb_car, nncc, nb_cl);		// you can safely adjust the size of the hidden layer (the middle argument)

	time(&debut);
	retro_propag_gradient(&brain, vec, nb_vec, num_cl, nb_car, nb_cl, nb_vec_cl, nb_iter_app, nncc, alpha);
	time(&fin);
	cout << "Duree de l'algorithme : " << difftime(fin, debut) << " secondes" << endl;
	cout << "---------------------------------------------------" << endl;

	destruct_vecteurs_donnees(vec, nb_vec);
	for(i=0 ; i<NB_CLASSES_MAX ; i++)
		free(nom_cl_i[i]);

	return 1;
}
