/*-------------------------------------------------------------------------
							TP RdF - B. Decoux
	rdf.h
	Prototypes des fonctions de 'rdf.c'
-------------------------------------------------------------------------*/
#ifndef RDF
#define RDF

/*#define RANDOM_MAX	2147483647  (pour linux)*/
#include "define.h"

typedef struct {
		float	*comp;	/*pointeur sur les composantes*/
		int	dim;		/*nombre de composantes*/
		int	n_cl;		/*numéro de classe*/
		int	num;		/*numéro de vecteur*/
		char	nom[50];	/*nom de la classe*/
		} Vec;

typedef struct {
		Vec	*vec;		/*pointeur sur les vecteur de la classe*/
		int	nb_vec;		/*nombre de vecteur dans la classe*/
		Vec	repr;		/*vecteur représentant de la classe*/
		int	num;		/*numéro de la classe*/
		} Classe;

float	alea_0a1();
float	dist_eucl_vec(Vec *vec1, Vec *vec2);
int	num_plus_proche(Vec *veci, int num_vec, Vec *vec, int nb_vec);
int	indice_classe_plus_proche(Classe *cl, int nb_cl, Vec *vec);
void	copie_vecs(Vec *vec1, Vec *vec2);
Vec*	creation_vecteurs_donnees(int nb_vec, int taille);
void	destruct_vecteurs_donnees(Vec *vec, int nb_vec);
Classe*	creation_classes(int nb_classes, int taille, int nb_vec);
void	destruct_classes(Classe *cl, int nb_classes, int nb_vec);
void	calcul_moyenne(Vec *vec, int nb_vec, Vec *vec_moy);
void	calcul_moyenne2(Vec *vec, int nb_vec, Vec *vec_moy);
void	affich_vec_txt(Vec *vec);
void	affich_vec_txt_fich(Vec	*vec, FILE *pf);
void	affich_liste_vec(Vec *vec, int nb_vec);
void	retirer_vec_liste(Vec *vec, int *nb_vec, int num);
int	num_min_tab_float(float *tab, int nb_val);
void	retirer_elt_tab_float(float *tab, int nb_val, int num);
void	charge_donnees_fich(char *nom_fich, Vec *vec, int nb_vec, int taille, int nb_cl, char **nom_cl_i);
void	normalis_vecs(Vec *vec, int nb_vec, int taille);
//VOID	gene_bases_app_et_reco(Vec *vec, int nb_vec, int nb_car, int nb_classes, int *num_cl, int *nb_vec_cl, Vec *vec_a, int *nb_vec_a, Vec **vec_cl_a, int *nb_vec_cl_a, Vec *vec_t, int *nb_vec_t, Vec **vec_cl_t, int *nb_vec_cl_t);
VOID	gene_bases_app_et_reco(Vec *vec, int nb_vec, int nb_car, int nb_classes, int *num_cl, int *nb_vec_cl, Vec *vec_a, int *nb_vec_a, int *num_cl_a, Vec *vec_t, int *nb_vec_t, int *num_cl_t);
void		lect_info_fich_donnees(char *nom_fich, int *nb_car, int *nb_vec, int *nb_cl, int *nb_vec_cl, char **nom_cl_i);
void		lect_info_fich_donnees2(char *nom_fich, int *nb_car, int *nb_vec, int *nb_cl, int *nb_vec_cl, char **nom_cl_i, int *num_cl);

#endif



