/*-------------------------------------------------------------------------
		TP RdF - B. Decoux - www-rdf.efrei.fr - decoux@efrei.fr
	rdf.c

	Fonctions utilitaires pour la reconnaissance de formes
-------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "rdf.h"
#include "define.h"

/*retourne une valeur comprise entre 0 et 1*/
float
alea_0a1()
{
	return (float)rand()/RAND_MAX;
}
FLOAT
aleat_gauss(FLOAT m, FLOAT s)
	// m : moyenne
	// s : sigma carré (variance)
{
	FLOAT	v=0;			// variable
	UBYTE	i;
	UBYTE	nb_va=12;	// nombre de variables aléatoires

	for(i=1 ; i<nb_va ; i++)
		v+=alea_0a1();
	return sqrt(s)*(v-6)+m;
}
FLOAT
aleat_gauss2(FLOAT m, FLOAT s)
	// m : moyenne
	// s : sigma carré (variance)
{
	FLOAT	v=0;			// variable
	UBYTE	i;
	UBYTE	nb_va=24;	// nombre de variables aléatoires

	for(i=1 ; i<nb_va ; i++)
		v+=alea_0a1();
	return sqrt(s)*(v-nb_va/2)*12/nb_va+m;
}
/*retourne la distance euclidienne entre 2 vecteurs*/
float
dist_eucl_vec(Vec *vec1, Vec *vec2)
{
	float	dist;
	int	i;

	dist=0.;
	for(i=0 ; i<vec1->dim ; i++)
		dist+=(*(vec1->comp+i)-*(vec2->comp+i))*(*(vec1->comp+i)-*(vec2->comp+i));
	return (float)sqrt(dist);
}
/*retourne le numéro de vecteur le plus proche du vecteur pointé par 'veci', dans l'ensemble des vecteurs pointés par 'vec'*/
int
num_plus_proche(Vec *veci, int num_vec, Vec *vec, int nb_vec)
{
	int	num_pp, i;
	float	dist, dist_min;

	dist_min=100000.;
	for(i=0 ; i<nb_vec ; i++)
	{
		dist=dist_eucl_vec(vec+i, veci);
		if(dist<dist_min)
		{
			num_pp=i;
			dist_min=dist;
		}
	}
	return num_pp;
}
/*retourne l'indice de la classe la plus proche du vecteur pointé par 'vec'*/
int
indice_classe_plus_proche(Classe *cl, int nb_cl, Vec *vec)
{
	int	num_cl, i;
	float	dist, dist_min;

	dist_min=100000.;
	for(i=0 ; i<nb_cl ; i++)
	{
		dist=dist_eucl_vec(vec, &((cl+i)->repr));
		if(dist<dist_min)
		{
			dist_min=dist;
			num_cl=(cl+i)->num;
		}
	}
	return num_cl;
}
/*copie des composantes d'un vecteur dans un autre vecteur*/
void
copie_vecs(Vec *vec1, Vec *vec2)
{
	int	i;

	for(i=0 ; i<vec1->dim ; i++)
		*(vec2->comp+i)=*(vec1->comp+i);
	vec2->dim=vec1->dim;
	vec2->n_cl=vec1->n_cl;
	strcpy(vec2->nom, vec1->nom);
	vec2->num=vec1->num;
}
/*Allocation mémoire pour un ensemble de 'nb_vec' vecteurs de taille 'taille'*/
Vec*
creation_vecteurs_donnees(int nb_vec, int taille)
{
	Vec	*vec;
	int	i;

	vec=(Vec*)calloc(nb_vec, sizeof(Vec));
	for(i=0 ; i<nb_vec ; i++)
	{
		(vec+i)->comp=(float*)calloc(taille, sizeof(float));
		(vec+i)->dim=taille;
	}
	return vec;
}
/*Désallocation mémoire pour un ensemble de vecteurs*/
void
destruct_vecteurs_donnees(Vec *vec, int nb_vec)
{
	int	i;

	for(i=0 ; i<nb_vec ; i++)
		free((vec+i)->comp);
	free(vec);
}
//normalisation d'un ensemble de vecteurs
void
multipl_vecs_cte(Vec *vec, int nb_vec, int taille, float cte)
{
	int	i, j;

	for(j=0 ; j<taille ; j++)
	{
	   for(i=0 ; i<nb_vec ; i++)
		*((vec+i)->comp+j)*=10.;
	}
}
/*Allocation mémoire pour un ensemble de 'nb_classes' de taille 'taille'*/
Classe*
creation_classes(int nb_classes, int taille, int nb_vec)
{
	Classe	*cl;
	int	i, j;

	cl=(Classe*)calloc(nb_classes, sizeof(Classe));
	for(i=0 ; i<nb_classes ; i++)
	{
		(cl+i)->repr.comp=(float*)calloc(taille, sizeof(float));
		(cl+i)->repr.dim=taille;
		(cl+i)->nb_vec=0;
		(cl+i)->vec=(Vec*)calloc(nb_vec, sizeof(Vec));
		for(j=0 ; j<nb_vec ; j++)
		{
			((cl+i)->vec+j)->comp=(float*)calloc(taille, sizeof(float));
			((cl+i)->vec+j)->dim=taille;
		}
	}
	return cl;
}
/*Désallocation mémoire pour un ensemble de classes*/
void
destruct_classes(Classe *cl, int nb_classes, int nb_vec)
{
	int	i, j;

	for(i=0 ; i<nb_classes ; i++)
	{
	    free((cl+i)->repr.comp);
	    free((cl+i)->vec);
	    for(j=0 ; j<nb_vec ; j++)
			free(((cl+i)->vec+j)->comp);
	}
	free(cl);
}
void
affich_classes(Classe *cl, int nb_cl)
{
	int	i;

	for(i=0 ; i<nb_cl ; i++)
	{
		printf("Classe %d : %d vecteurs\n", i, (cl+i)->nb_vec);
	}
}
/*normalisation d'un ensemble de vecteurs*/
void
normalis_vecs(Vec *vec, int nb_vec, int taille)
{
	int	i, j;
	float	cmax;

	for(j=0 ; j<taille ; j++)
	{
	   cmax=0.;
	   for(i=0 ; i<nb_vec ; i++)
		if(*((vec+i)->comp+j)>cmax)
			cmax=*((vec+i)->comp+j);
	   if(cmax!=0.)
		for(i=0 ; i<nb_vec ; i++)
			*((vec+i)->comp+j)/=cmax;
	}
}
// Calcul d'un vecteur moyen de manière récursive
// (moyenne d'un ensemble de 'nb_vec' vecteurs, en utilisant la moyenne de 'nb_vec-1' vecteurs)
void
calcul_moyenne(Vec *vec, int nb_vec, Vec *vec_moy)
{
	int	i;

	for(i=0 ; i<vec->dim ; i++)
		*(vec_moy->comp+i)=(*(vec->comp+i)+(nb_vec-1)**(vec_moy->comp+i))/nb_vec;
}
void
calcul_moyenne_rec_moins(Vec *vec, int nb_vec, Vec *vec_moy)
{
	int	i;

	for(i=0 ; i<vec->dim ; i++)
		*(vec_moy->comp+i)=(nb_vec**(vec_moy->comp+i)-*(vec->comp+i))/(nb_vec-1);
}
/*Calcul du vecteur moyen d'un ensemble de 'nb_vec' vecteurs : méthode classique*/
void
calcul_moyenne2(Vec *vec, int nb_vec, Vec *vec_moy)
{
	int		i, j;

	for(i=0 ; i<vec->dim ; i++)
		*(vec_moy->comp+i)=0;
	for(j=0 ; j<nb_vec ; j++)
	   for(i=0 ; i<vec->dim ; i++)
		*(vec_moy->comp+i)+=*((vec+j)->comp+i);
	for(i=0 ; i<vec->dim ; i++)
		*(vec_moy->comp+i)/=nb_vec;
}
void
init_vec_zero(Vec *vec)
{
	int		i;

	for(i=0 ; i<vec->dim ; i++)
		*(vec->comp+i)=0.;
}
/*Affichage d'un vecteur en mode texte*/
void
affich_vec_txt(Vec *vec)
{
	int	i;

	for(i=0 ; i<vec->dim ; i++)
		printf("%.2f  ", *(vec->comp+i));
	printf("\n");
}
/*Affichage d'un vecteur en mode texte dans un fichier*/
void
affich_vec_txt_fich(Vec *vec, FILE *pf)
{
	int	i;

	for(i=0 ; i<vec->dim ; i++)
		fprintf(pf, "%.2f  ", *(vec->comp+i));
	fprintf(pf, "\n");
}
/*Affichage en mode texte d'une liste de vecteurs*/
void
affich_liste_vec(Vec *vec, int nb_vec)
{
	int	i;

	for(i=0 ; i<nb_vec ; i++)
		affich_vec_txt(vec+i);
}
/*Retrait d'un vecteur d'une liste*/
void
retirer_vec_liste(Vec *vec, int *nb_vec, int num)
	/* num : numéro du vecteur à retirer */
{
	int	i;

	for(i=num ; i<*nb_vec-1 ; i++)
		copie_vecs(vec+i+1, vec+i);
	(*nb_vec)--;
}
/*retourne l'indice de l'élément minimal d'un tableau de float*/
int
num_min_tab_float(float *tab, int nb_val)
{
	float	min;
	int	i, num=0;

	min=*(tab+0);
	for(i=0 ; i<nb_val ; i++)
	{
		if(*(tab+i)<min)
		{
			min=*(tab+i);
			num=i;
		}
	}
	return	num;
}
/*retire l'élément d'indice 'num' d'un tableau de float*/
void
retirer_elt_tab_float(float *tab, int nb_val, int num)
{
	int	i;

	for(i=num ; i<nb_val ; i++)
		*(tab+i)=*(tab+i+1);
}
/*------------------------------------------------------------------------
	lect_info_fich_donnees
	Lecture des informations dans un fichier de données (au format adéquat) : 
		- nombre de vecteurs (nb_vec)
		- taille des vecteurs	(nb_car)
		- nombre de classes (nb_cl)
		- nombre de vecteurs pour chaque classe	(nb_vec_cl)
		- nom des classes (nom_cl_i)
------------------------------------------------------------------------*/
void
lect_info_fich_donnees(char *nom_fich, int *nb_car, int *nb_vec, int *nb_cl, int *nb_vec_cl, char **nom_cl_i)
{
	FILE	*pf;
	float	var;
	int	res;
	int	i, j, k;
	char	c, nom_cl[30];		/*nom classe*/
	int	existe;

	if((pf=fopen(nom_fich, "r"))==NULL)
	{
		printf("Erreur ouverture fichier '%s' en lecture...\n", nom_fich);
		exit(1);
	}
   /*comptage du nombre de variables (principe : comptage du nombre de virgules avant le retour à la ligne)*/
	*nb_car=0;
	do
	{
		fscanf(pf, "%c", &c);
		if(c==' ')
		     (*nb_car)++;

	} while(c!='\n');

   /*comptage du nombre de lignes (=nombre vecteurs)*/
	rewind(pf);					/*retour en début de fichier*/
	*nb_vec=0;
	do
	{
	   for(i=0 ; i<*nb_car ; i++)
		res=fscanf(pf, "%f", &var);
	   fscanf(pf, "%s", nom_cl);
	   (*nb_vec)++;
	} while(res>0);
	(*nb_vec)--;

   /*recherche du nombre de classes*/
	rewind(pf);
	*nb_cl=0;
	strcpy(*(nom_cl_i+*nb_cl), "");
	for(j=0 ; j<*nb_vec ; j++)
	{
	   for(i=0 ; i<*nb_car ; i++)				/*lecture des variables*/
		fscanf(pf, "%f", &var);
	   fscanf(pf, "%s", nom_cl);			/*lecture du nom de la classe*/
	   existe=0;					/*on cherche si ce nom existe déjà*/
	   for(k=0 ; k<=*nb_cl ; k++)
	   {
	     if(strcmp(nom_cl, *(nom_cl_i+k))==0)		/*si oui on continue*/
		existe=1;
	   }
	   if(existe==0)					/*si non on mémorise ce nom*/
	   {						/*et on incrémente le nombre de classes*/
		strcpy(*(nom_cl_i+*nb_cl), nom_cl);
		(*nb_cl)++;
	   }
	}

    /*comptage du nombre d'exemples pour chaque classe*/
	rewind(pf);
	for(j=0 ; j<*nb_vec ; j++)
	{
	   for(i=0 ; i<*nb_car ; i++)
		fscanf(pf, "%f", &var);
	   fscanf(pf, "%s", nom_cl);
	   for(k=0 ; k<*nb_cl ; k++)
	     if(strcmp(nom_cl, *(nom_cl_i+k))==0)
		(*(nb_vec_cl+k))++;
	}
	fclose(pf);
}
/*-----------------------------------------------------------------------------------------------------------
	Fonction "lect_info_fich_donnees2()"
	Même chose que "lect_info_fich_donnees()" mais avec en plus un 
		indice de classe pour chaque vecteur 
	Lecture des informations dans un fichier de données (au format adéquat .don).
	Retourne les inform	ations suivantes :
		- nombre de vecteurs (nb_vec)
		- taille des vecteurs	(nb_car)
		- nombre de classes (nb_cl)
		- nombre de vecteurs pour chaque classe	(nb_vec_cl)
		- nom des classes (nom_cl_i)
		- indice de classe pour chaque vecteur : de 1 à nombre de classes (num_cl)
------------------------------------------------------------------------------------------------------------*/
void
lect_info_fich_donnees2(char *nom_fich, int *nb_car, int *nb_vec, int *nb_cl, int *nb_vec_cl, char **nom_cl_i, int *num_cl)
{
	FILE	*pf;
	float	var;
	int	res;
	int	i, j, k;
	char	c;
	char nom_cl[30];		// nom classe
	int	existe;

	if((pf=fopen(nom_fich, "r"))==NULL)
	{
		printf("Erreur ouverture fichier '%s' en lecture...\n", nom_fich);
		exit(1);
	}

   // comptage du nombre de variables (principe : comptage du nombre de virgules avant le retour à la ligne)
	*nb_car=0;
	do
	{
		fscanf(pf, "%c", &c);
		if(c==' ')
		     (*nb_car)++;

	} while(c!='\n');

   // comptage du nombre de lignes (=nombre vecteurs)
	rewind(pf);					// retour en début de fichier
	*nb_vec=0;
	do
	{
	   for(i=0 ; i<*nb_car ; i++)
		res=fscanf(pf, "%f", &var);
	   fscanf(pf, "%s", nom_cl);
	   (*nb_vec)++;
	} while(res>0);
	(*nb_vec)--;

   // recherche du nombre de classes
	rewind(pf);
	*nb_cl=0;
	strcpy(*(nom_cl_i+*nb_cl), "");
	for(j=0 ; j<*nb_vec ; j++)
	{
	   for(i=0 ; i<*nb_car ; i++)				// lecture des variables
		fscanf(pf, "%f", &var);
	   fscanf(pf, "%s", nom_cl);			// lecture du nom de la classe
	   existe=0;					// on cherche si ce nom existe déjà
	   for(k=0 ; k<=*nb_cl ; k++)
	   {
	     if(strcmp(nom_cl, *(nom_cl_i+k))==0)		// si oui on continue
		existe=1;
	   }
	   if(existe==0)			// sinon on mémorise ce nom et on incrémente le nombre de classes
	   {
		strcpy(*(nom_cl_i+*nb_cl), nom_cl);
		(*nb_cl)++;
	   }
	}

    // comptage du nombre d'exemples pour chaque classe
	rewind(pf);
	for(k=0 ; k<*nb_cl ; k++)
		*(nb_vec_cl+k)=0;
	for(j=0 ; j<*nb_vec ; j++)
	{
	   for(i=0 ; i<*nb_car ; i++)
		fscanf(pf, "%f", &var);
	   fscanf(pf, "%s", nom_cl);
	   for(k=0 ; k<*nb_cl ; k++)
	     if(strcmp(nom_cl, *(nom_cl_i+k))==0)
	     {
		(*(nb_vec_cl+k))++;
		*(num_cl+j)=k+1;
	     }
	}
	fclose(pf);

	// Sauvegarde du nom des classes dans un fichier (en cas de besoin)
	pf=fopen("classes.txt", "w");
	fprintf(pf, "%d\n", *nb_cl);
	for(i=0 ; i<*nb_cl ; i++)
	{
		//printf("%s\n", *(nom_cl_i+i));
		fprintf(pf, "%s\n", *(nom_cl_i+i));
	}
	fclose(pf);
}

// Fonction de séparation de la base des vecteurs, en une base d'apprentissage et une base de test
// Séparation des données en 2 sous-ensembles : un pour l'apprentissage et l'autre pour la reconnaissance
// pour chaque classe : la moitié pour l'apprentissage et l'autre pour le test
// dans le cas où l'effectif est impair, on en met un de plus pour l'apprentissage
// 		Variables d'entrée :
//			vec : 		liste de tous les vecteurs
//			nb_vec :		nombre de vecteurs dans cette liste
//			nb_car :		nombre de composantes des vecteurs (=nombre de caractéristiques)
//			nb_classes :	nombre de classes
//			num_cl :		numéro de classe de chacun des vecteurs de la liste 'vec'
// 		Variables de sortie :
//			vec_a :		liste des vecteurs d'apprentissage
//			nb_vec_a :	nombre de vecteurs dans cette liste
//			vec_t :		liste des vecteurs de test
//			nb_vec_t :	nombre de vecteurs dans cette liste
//---------------------------------------------------------------------------------------------------------------------------------
void
gene_bases_app_et_reco(Vec *vec, int nb_vec, int nb_car, int nb_classes, int *num_cl, int *nb_vec_cl, Vec *vec_a, int *nb_vec_a, int *num_cl_a, Vec *vec_t, int *nb_vec_t, int *num_cl_t)
{
	int	compt1=0;
	int	compt2=0;
	int	i, j, k;
	int	num_vec;

	*nb_vec_a=0;
	*nb_vec_t=0;
	for(k=0 ; k<nb_classes ; k++)
	{
		compt1=0;
		compt2=0;
		for(j=0 ; j<nb_vec ; j++)
		{
			if(*(num_cl+j)==k+1 && compt1<(int)(*(nb_vec_cl+k)/2))
			{
				compt1++;
				copie_vecs(vec+j, vec_a+*nb_vec_a);
				(*nb_vec_a)++;
				*(num_cl_a+*nb_vec_a)=*(num_cl+j);
			}
			else if(*(num_cl+j)==k+1 && compt1+compt2<*(nb_vec_cl+k))
			{
				compt2++;
				copie_vecs(vec+j, vec_t+*nb_vec_t);
				(*nb_vec_t)++;
				*(num_cl_t+*nb_vec_t)=*(num_cl+j);
			}
		}
	}
}
//-----------------------------------------------------------------------------------------
//	Chargement d'un fichier de données
//	Le format doit être le suivant :
//		-un vecteur de données sur chaque ligne
//		-les différentes variables (composantes des vecteurs) séparées entre elle par des espaces
//		-le nom de la classe (qui peut être un numéro) en fin de ligne
//-----------------------------------------------------------------------------------------
void
charge_donnees_fich(char *nom_fich, Vec *vec, int nb_vec, int taille, int nb_cl, char **nom_cl_i)
{
 	char	nom_classe[50];
	FILE	*pf;
	int	i, j, k;

	if((pf=fopen(nom_fich, "r"))==NULL)
	{
		printf("Erreur ouverture fichier '%s' en lecture...\n", nom_fich);
		exit(1);
	}
	for(i=0 ; i<nb_vec ; i++)
	{
		for(j=0 ; j<taille ; j++)
			fscanf(pf, "%f", (vec+i)->comp+j);
		fscanf(pf, "%s", nom_classe);
		strcpy((vec+i)->nom, nom_classe);
		for(k=0 ; k<nb_cl ; k++)				/*on donne un numéro à chaque classe*/
		   if(strcmp((vec+i)->nom, nom_cl_i[k])==0)
			(vec+i)->n_cl=k+1;
		(vec+i)->num=i+1;
	}
	fclose(pf);
}




