/*#####################################################
 * FILE NAME	: define.h
 * 		STANDARD DEFINE
 #####################################################*/

#ifndef DEFINE
#define DEFINE

#include <limits.h>
#define BYTE		char
#define UBYTE		unsigned char
#define TEXT		char
#define WORD		short
#define UWORD		unsigned short
#define LONG		long
#define ULONG		unsigned long
#define FLOAT   	float
#define DOUBLE  	double

#define BYTE_MAX        CHAR_MAX
#define BYTE_MIN        CHAR_MIN
#define UBYTE_MAX       UCHAR_MAX
#define WORD_MAX        SHRT_MAX
#define WORD_MIN        SHRT_MIN
#define UWORD_MAX       USHRT_MAX
#define VOID		void
#define REG		register
#define STATIC		static
#define EXTERN		extern

#define FAILURE (-1)
/*#define SUCCESS (0)*/
#define YES     1
#define NO      0
#define TRUE    1
#define FALSE   0
#define ERROR   -1
#define OUI		1
#define NON		0
#define VRAI		1
#define FAUX		0

#ifndef NULL
#define NULL	0
#endif

#define XCHG_SHORT(x) ((((x)&0xFF)<<8) | (((x)>>8)&0xFF))
#ifdef __i486__
# define XCHG_LONG(x) \
     ({ int32 __value; \
        asm ("bswap %1; movl %1,%0" : "=g" (__value) : "r" (x)); \
       __value; })
#else
#define XCHG_LONG(x) ((((x)&0xFF)<<24) | (((x)&0xFF00)<<8) | (((x)&0xFF0000)>>8) | (((x)>>24)&0xFF))
#endif

#define LE_SHORT(x) x
#define LE_LONG(x) x
#define BE_SHORT(x) XCHG_SHORT(x)
#define BE_LONG(x) XCHG_LONG(x)

//ULONG MEM_UTIL;
//BYTE *alloc();

#endif


